<?php 
/** 
*  Database class to implement singleton pattern on top of mysqli 
*/ 
class singleton extends mysqli 
{ 
   /** 
   *  @var object Singleton instance 
   */ 
   private static $instance = null; 
   // DB connection parameters: 
   private $dbHost = 'localhost'; 
   private $dbUser = 'root'; 
   private $dbPwd  = 'root'; 
   private $dbName = 'postventa'; 
    
   /** 
   *  Constructor 
   *  @return void 
   */ 
   private function __construct() 
   { 
      @parent::__construct( 
         $this->dbHost, 
         $this->dbUser, 
         $this->dbPwd, 
         $this->dbName 
      ); 
      if(mysqli_connect_errno()) 
      { 
         throw new Exception( 
            mysqli_connect_error(),  
            mysqli_connect_errno() 
         ); 
      } 
   } 
    
   /** 
   *  Do the singleton thing 
   *  @return object Database 
   */ 
   public function getInstance() { 
      if(self::$instance === null) 
      { 
         $c = __CLASS__; 
         self::$instance = new $c;  
      } 
      return self::$instance; 
   } 

   public function __clone() 
   { 
      throw new Exception("Cannot clone ".__CLASS__." class"); 
   } 




}